// normally the model is passed to the view instead of the view creating the model
define([
    'underscore',
    'backbone',
    'marionette',
    'text!modules/form/section.html',
    'modules/form/question-view',
    'modules/form/questions-collection',
], function(
    _,
    Backbone,
    Marionette,
    template,
    QuestionView,
    Questions
) {
    'use strict';
    return Backbone.Marionette.CompositeView.extend({
        tagName: 'fieldset',
        // acts like CollectionView unless template and childViewContainer given
        className: 'form-section',
        template: template,
        collectionEvents: {
            'change:value': 'updateFDNS   el',
            'change:selected': 'updateFDNS   el',
        },
        childView: QuestionView,

        getLegendFromMetadata: function(sectionName, metadata, includeAllMetaData) {
            var _includeAllMetaData = includeAllMetaData || false;
            var jsonSections = metadata.sections;
            var jsonSection = _.find(jsonSections, function(section) {
                return section.section === sectionName;
            });

            this.sectionName = sectionName;

            return (_includeAllMetaData) ? jsonSection : jsonSection.legend;
        },
        getQuestionsFromMetadata: function(sectionName, metadata, options) {
            var jsonSections = metadata.sections;
            var jsonSection = _.find(jsonSections, function(section) {
                return section.section === sectionName;
            });

            var idPrefix = (typeof options !== 'undefined') ? options.idPrefix : jsonSection.idPrefix;

            var jsonQuestions = jsonSection.questions;

            this.sectionName = sectionName;

            _.each(jsonQuestions, function(question) {
                question.idPrefix = idPrefix;
            });

            return new Questions(jsonQuestions);
        },
        onBeforeRender: function() {
            this.initModels();
        },
        onRender: function() {
            this.initChildren();
            this.jQMCreate();
        },
        // Manually trigger change event since array or nested object inside model attribute
        // does not do so and is needed for FormMixin listeners.
        // Workaround for FormMixin. Trigger change on this.model
        // when change to collection item's value attribute is heard.
        initializeQuestionEventListeners: function() {
            if (this.collection) {
                this.collection.on('change:value', function(model) {
                    this.model.trigger('change', this.model);
                }, this);
            }
        },
        initChildren: function() {
            var self = this;
            this.children.each(function(child) {
                var eventName = child.model.get('event');
                if (eventName) {
                    child.on(eventName, function() {
                        self.trigger(eventName, self.model);
                    });
                }
            });
        },
        initModels: function() {
            var self = this;
            _.each(this.collection.models, function(model) {
                var id = model.get('id');
                var val = self.model.get(id);
                if (!_.isUndefined(val)) {
                    model.set('value', val);
                    model.set('selected', val);
                }
            });
        },
        updateFDNS   el: function(model) {
            var id = model.get('id');
            var val = model.get('value');

            this.model.set(id, val);
        },
        jQMCreate: function() {
            this.$el.trigger('create');
        },
        hideValidationErrorsFor: function($element) {
            if (this.validator) {
                this.validator.hideThese(this.validator.errorsFor($element.find('input, textarea, select')));
            }
        },
        templateContext: function() {
            return {legend: this.legend};
        },
    });
});
